from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static

from links_manager import views as links_views
from . import views


urlpatterns = [
    path('account/', include('accounts.urls')),
    path('account', include('accounts.urls')),
    path('tinymce/', include('tinymce.urls')),
    path('contact/', views.contact, name='contact'),
    path('p/', include('pages.urls')),
    path('<slug:slug>', links_views.go_page),
    path('', views.home, name='home'),
]

urlpatterns.extend([
    *static(settings.STATIC_URL, document_root=settings.STATIC_ROOT),
    *static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
])

# Override default django error pages (works just on production).
handler400 = "app.views.Page400"
handler404 = "app.views.Page404"
handler403 = "app.views.Page403"
handler500 = "app.views.Page500"
